define([
		'app',
        'UserGuideController',
        'UserGuideConstants'
	],
	function (app) {
		"use strict";

		app.config(function ($stateProvider) {
			$stateProvider
				.state('main.help', {
					url: '/user-guide',
					appNavIndex: 9,                    
					containerClass : 'help',
					data: {
						appletName: "Help",
                        sectionName : "user-guide",
                        icon : "help",                        
						baseStateName : 'main.help',
						initialState : 'help'                     
                    },
					views : {
                        "@main": {
                            templateUrl: 'src/container/components/content/single-column_template.html'
                        },
                        'primary@main.help': {
                            templateUrl: 'src/modules/user-guide/pages/user-guide_template.html',
                            controller: 'UserGuideController'
                        }
					}
				});
        });
    }
);
